<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ManufacturingOrder;
use App\Warehouse;
use App\MakeProduct;
use App\Product_Warehouse;
use App\ProductionUnit;
use App\Product;
use App\Unit;


class ManufacturingOrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lims_manufacturingOrder_data = ManufacturingOrder::with('makeProduct.product','warehouse')
            ->where(['is_active'=>true,'is_end'=>false])
            ->orderBy('id','DESC')->get();

        return view('manufacturingOrder/index',compact('lims_manufacturingOrder_data'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $lims_unit_list = Unit::where('is_active',true)->latest()->get();

        $lims_warehouses_data = Warehouse::where('is_active',true)
            ->orderby('id','DESC')->get();

        $lims_makeProduct_data = MakeProduct::with('child.product','product')
            ->where('is_active',true)->orderby('id','DESC')->get();

        return view('manufacturingOrder.create',
            compact('lims_makeProduct_data','lims_warehouses_data','lims_unit_list'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $this->validate($request, [
            'make_product_id' => [
                'required'
            ],'amount' => [
                'required'
            ],'warehouse_id' => [
                'required'
            ],'notes'=>[
                'nullable'
            ]
        ]);

        $data['is_active'] = true;
        $data['is_end'] = false;

        ManufacturingOrder::create($data);

        return redirect('manufacturingOrder');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lims_manufacturingOrder_data = ManufacturingOrder::with('makeProduct.product')
            ->findORFail($id);


        $lims_warehouses_data = Warehouse::where('is_active',true)
            ->orderby('id','DESC')->get();

        $lims_unit_list = Unit::where('is_active',true)->latest()->get();


        return view('manufacturingOrder.edit',
            compact('lims_warehouses_data','lims_manufacturingOrder_data','lims_unit_list'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {


        $data = $this->validate($request, [
            'waste' => [
                'required'
            ],'product_id' => [
                'required'
            ],'amount' => [
                'required'
            ],'warehouse_id' => [
                'required'
            ],'notes'=>[
                'nullable'
            ]
        ]);

        $totalAmount = $request->amount + $request->waste;


        $findManufacturingOrder = ManufacturingOrder::with('makeProduct.child.product')->find($id);


        if ($findManufacturingOrder->amount != $totalAmount){

            return redirect()->back()->with('not_permitted', 'the amount wrong!!');
        }

        foreach ($findManufacturingOrder->makeProduct->child as $childCheck){
            $findToCheck = Product_Warehouse::where(['product_id'=>$childCheck->product_id
                ,'warehouse_id'=>$findManufacturingOrder->warehouse_id])->first();

            $countToCheck = Product_Warehouse::where(['product_id'=>$childCheck->product_id
                ,'warehouse_id'=>$findManufacturingOrder->warehouse_id])->count();

            if ($countToCheck != 0){


                $checkQty =  $findToCheck->qty;



                $productValUnit = Product::find($childCheck->product_id);

                if ($productValUnit->unit_id != $childCheck->unit_id){

                    $findCheckUnit = Unit::find($childCheck->unit_id);

                    if ($findCheckUnit){
                        if ($findCheckUnit->operator == '*'){

                                $checkQty = $checkQty * $findCheckUnit->operation_value;
                            }else{
                                $checkQty = $checkQty / $findCheckUnit->operation_value;
                            }
                        }

                }
                $minusQtyCheck = $childCheck->amount * $findManufacturingOrder->amount;


                if ($checkQty < $minusQtyCheck){

                    return redirect()->back()->with('not_permitted', 'the qty is not Enough!!');
                }
            }else{
                return redirect()->back()->with('not_permitted', 'the amount wrong!!');
            }

        }


         foreach ($findManufacturingOrder->makeProduct->child as $child){
             $findFromStock = Product_Warehouse::where(['product_id'=>$child->product_id
                 ,'warehouse_id'=>$findManufacturingOrder->warehouse_id])->first();

             $countFromStock = Product_Warehouse::where(['product_id'=>$child->product_id
                 ,'warehouse_id'=>$findManufacturingOrder->warehouse_id])->count();


             $minusQty = $child->amount * $findManufacturingOrder->amount;


             if ($countToCheck != 0){
                 $oldQty =  $findFromStock->qty;


                 $editMinusProduct = Product::find($child->product_id);

                 $oldEditQty = $editMinusProduct->qty;


                 $productUnit = Product::find($child->product_id);
                 if($productUnit){
                     if ($productUnit->unit_id != $child->unit_id){
                         $findUnit = Unit::find($child->unit_id);
                         if ($findUnit){

                             if ($findUnit->operator == '*'){

                                 $oldEditQty = $oldEditQty  * $findUnit->operation_value;
                                 $newEditAmount  = $oldEditQty - $minusQty;

                                 $newEditAmount = $newEditAmount / $findUnit->operation_value;
                                 $editMinusProduct->qty = $newEditAmount;




                                 ///////////////////// المستودع ///////////////////

                                 $oldQty = $oldQty * $findUnit->operation_value;


                                 $newStockQty = $oldQty - $minusQty;

                                 $newStockQty = $newStockQty / $findUnit->operation_value;
                                 $findFromStock->qty = $newStockQty;




                             }else{
                                 $oldEditQty = $oldEditQty  / $findUnit->operation_value;
                                 $newEditAmount  = $oldEditQty - $minusQty;

                                 $newEditAmount = $newEditAmount * $findUnit->operation_value;
                                 $editMinusProduct->qty = $newEditAmount;


                                 ///////////////////// المستودع ///////////////////

                                 $oldQty = $oldQty / $findUnit->operation_value;


                                 $newStockQty = $oldQty - $minusQty;

                                 $newStockQty = $newStockQty * $findUnit->operation_value;
                                 $findFromStock->qty = $newStockQty;
                             }
                         }

                     }else{
                         $editMinusProduct->qty = $oldEditQty - $minusQty;
                         $findFromStock->qty = $oldQty - $minusQty;

                     }
                 }


                 $findFromStock->save();

                 $editMinusProduct->save();
             }else{
                 return redirect()->back()->with('not_permitted', 'the amount wrong!!');
             }

         }

        $data['is_active'] = true;
        $data['manufacturing_order_id'] = $id;

        ProductionUnit::create($data);

        $findCountStock = Product_Warehouse::where(['product_id'=>$request->product_id,
            'warehouse_id'=>$request->warehouse_id])->count();

        if ($findCountStock != 0){
            $findNewStock = Product_Warehouse::where(['product_id'=>$request->product_id,
                'warehouse_id'=>$request->warehouse_id])->first();
        }else{
            $findNewStock = new Product_Warehouse();
            $findNewStock->product_id = $request->product_id;
            $findNewStock->qty = 0;
            $findNewStock->warehouse_id = $request->warehouse_id;
        }
        $newAmount = $findNewStock->qty + $request->amount;

        $findNewStock->qty = $newAmount;

        $findNewStock->save();



        $editPlusProduct = Product::find($request->product_id);


        $newPlusQty = $editPlusProduct->qty;

        $editPlusProduct->qty = $newPlusQty + $request->amount;

        $editPlusProduct->save();


        $findManufacturingOrder->is_end = true;

        $findManufacturingOrder->save();

        return redirect('productionLine');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $lims_manufacturing_data = ManufacturingOrder::findOrFail($id);
        $lims_manufacturing_data->is_active = false;
        $lims_manufacturing_data->save();

        return redirect('manufacturingOrder')->with('not_permitted', 'Data deleted successfully');


    }//end fun
    /**
     * @param Request $request
     * @return string
     */
    public function deletebyselection(Request $request){
        foreach ($request->manufacturingIdArray as $id){
            $lims_manufacturing_data = ManufacturingOrder::findOrFail($id);
            $lims_manufacturing_data->is_active = false;
            $lims_manufacturing_data->save();
        }
        return 'Data deleted successfully';

    }//end fun
    public function manufacturingOrderGetProducts(Request $request){

        $lims_makeProduct_data = MakeProduct::with('child.product','child.unit')
            ->find($request->make_product_id);


//        return $lims_makeProduct_data;
        $html = '';


        foreach ($lims_makeProduct_data->child as $key =>$child){
            $count = $key +1;
            $amount = $child->amount * $request->amount;
            $html.='<tr>
                        <td><span class="sn">'.$count.'</span>.</td>
                        <td>'.$child->product->name.'</td>
                        <td>'.$amount . ' '.$child->unit->unit_name .'</td>
                        <td>'.$child->notes.'</td>
                    </tr>';
        }

        return $html;

    }//end fun

}//end class
