@extends('layout.main')
@section('content')

    @if(session()->has('message'))
        <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('message') }}</div>
    @endif

    @if(session()->has('not_permitted'))
        <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div>
    @endif
    <section class="forms">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center">
                            <h4>{{trans('file.Add production units')}}</h4>
                        </div>
                        <div class="card-body">
                            <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                            {!! Form::open(['route' => ['makeProduct.update',$lims_make_data->id], 'files' => true, 'method' => 'post']) !!}
                            <div class="row">
                                @method('PUT')
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{trans('file.Select Product')}} *</label>

                                        <select required name="product_id" class="form-control" data-live-search="true" data-live-search-style="begins" title="{{trans('file.Select final Product')}}...">
                                            @foreach($is_sale_product as $product)
                                                <option value="{{$product->id}}" {{$lims_make_data->product_id == $product->id?'selected':''}}>{{$product->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{trans('file.notes')}} </label>

                                        <input type="text" name="notes" value="{{$lims_make_data->notes}}"  class="form-control"  placeholder="{{trans('file.notes')}}..." >
                                    </div>
                                </div>
                                {{--                                <div class="col-md-6">--}}
                                {{--                                    <div class="form-group">--}}
                                {{--                                        <label>عدد المكونات*</label>--}}
                                {{--                                        <input type="text" class="form-control numbersOnly" id="productCount">--}}
                                {{--                                    </div>--}}
                                {{--                                </div>--}}
                                <div class="col-md-12">

                                    <div class="table-responsive-md col-sm-12" id="appendTo">
                                        <table class="table table-striped-table-bordered table-hover table-checkable table-" id="tbl_posts">
                                            <thead>
                                            <tr>

                                                <th>#</th>
                                                <th >{{trans('file.Select Product')}}</th>
                                                <th >{{trans('file.amount')}}</th>
                                                <th >{{trans('file.Unit')}}</th>
                                                <th >{{trans('file.notes')}}</th>
                                                <th>
                                                    <a class="btn btn-info add-record click" data-added="0"><i class="fa fa-plus"></i></a>
                                                </th>
                                            </tr>
                                            </thead>
                                            <tbody id="tbl_posts_body">
                                            @foreach($lims_make_data->child as $key=> $childProducts)
                                                    <tr id="rec-{{$key + 1}}" class="MainMakeProduct">
                                                        <td><span class="sn">{{$key + 1}}</span>.</td>
                                                        <td>
                                                            <select name="product_id_[]" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins">
                                                                <option value="">{{trans('file.Select Product')}}</option>
                                                                @foreach($no_sale_product as $no_product)
                                                                    <option value="{{$no_product->id}}" {{$childProducts->product_id == $no_product->id?'selected':''}} >{{$no_product->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <input type="text" name="amount_[]" value="{{$childProducts->amount}}" class="form-control"  placeholder="{{trans('file.amount')}}..." >
                                                        </td>
                                                        <td>
                                                            <select name="unit_id[]" required class="selectpicker form-control" data-live-search="true" data-live-search-style="begins">
                                                                <option value="" selected disabled>{{trans('file.Select Product')}}</option>
                                                                @foreach($lims_unit_data as $unit)
                                                                    <option value="{{$unit->id}}" {{ $childProducts->unit_id == $unit->id?'selected':''}}>{{$unit->unit_name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <input type="text" name="notes_[]" value="{{$childProducts->notes}}" class="form-control"  placeholder="{{trans('file.notes')}}..." >
                                                        </td>
                                                        <td><a class="btn btn-xs delete-record " data-id="{{$key + 1}}"><i style="color: #f4516c" class="fa fa-trash"></i></a></td>
                                                    </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div style="display:none;">
        <table id="sample_table">
            <tr id="">
                <td><span class="sn"></span>.</td>
                <td>
                    <select name="product_id_[]">
                        <option value="">{{trans('file.Select Product')}}</option>
                        @foreach($no_sale_product as $no_product)
                            <option value="{{$no_product->id}}">{{$no_product->name}}</option>
                        @endforeach
                    </select>
                </td>
                <td>
                    <input type="text" name="amount_[]"  class="form-control"  placeholder="{{trans('file.amount')}}..." >
                </td>
                <td>
                    <input type="text" name="notes_[]"  class="form-control"  placeholder="{{trans('file.notes')}}..." >
                </td>
                <td><a class="btn btn-xs delete-record " data-id="1"><i style="color: #f4516c" class="fa fa-trash"></i></a></td>
            </tr>
        </table>
    </div>

    <script type="text/javascript">

        $("ul#MakeProduct").siblings('a').attr('aria-expanded','true');
        $("ul#MakeProduct").addClass("show");
        $("ul#MakeProduct #MakeProduct-menu").addClass("active");

        $('.selectpicker').selectpicker('refresh');
        {{--$(document).ready(function (){--}}
        {{--    var url = '{{route('makeProduct.show',":id")}}';--}}
        {{--    url = url.replace(':id', 1);--}}
        {{--    $('#tbl_posts_body').load(url)--}}
        {{--})--}}
    </script>

    <script>
        $(document).on('keyup','.numbersOnly',function () {
            this.value = this.value.replace(/[^0-9\.]/g,'');
        });
        jQuery(document).delegate('a.add-record', 'click', function(e) {
            e.preventDefault();
            var  size = jQuery('#tbl_posts >tbody >tr').length + 1,
                content ,
                element = null,
                url = '{{route('makeProduct.show',":id")}}';
            url = url.replace(':id', size);
            $.get( url, function( data ) {
                $('#tbl_posts_body').append(data);
            });
            // element = content.clone();
            // element.attr('id', 'rec-'+size);
            // element.find('.delete-record').attr('data-id', size);
            // element.find('.sn').html(size);

        });
        jQuery(document).delegate('a.delete-record', 'click', function(e) {

            e.preventDefault();
            // var didConfirm = confirm("Are you sure You want to delete");
            // if (didConfirm == true) {


            var  countProducts = $('.MainMakeProduct').length

            console.log(countProducts)

            if (countProducts == 1){
                alert("{{trans('file.you can`t delete')}}")
                return true;
            }


            var id = jQuery(this).attr('data-id');
            var targetDiv = jQuery(this).attr('targetDiv');
            jQuery('#rec-' + id).remove();

            //regnerate index number on table
            $('#tbl_posts_body tr').each(function (index) {
                //alert(index);
                $(this).find('span.sn').html(index + 1);
            });
            return true;
            // } else {
            //   return false;
            // }
        });

    </script>
@endsection
