@extends('layout.main')
@section('content')

    @if(session()->has('message'))
        <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('message') }}</div>
    @endif

    @if(session()->has('not_permitted'))
        <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div>
    @endif
    <section class="forms">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center">
                            <h4>{{trans('file.end manufacturing order')}}</h4>
                        </div>
                        <div class="card-body">
                            <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                            {!! Form::open(['route' => ['manufacturingOrder.update',$lims_manufacturingOrder_data->id], 'files' => true, 'method' => 'post']) !!}
                            <div class="row">
                                @method('PUT')
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{trans('file.Product Name')}} *</label>
                                        <input class="form-control" disabled value="{{$lims_manufacturingOrder_data->makeProduct->product->name??''}}">
                                        <input class="form-control" hidden name="product_id" value="{{$lims_manufacturingOrder_data->makeProduct->product->id??''}}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{trans('file.amount')}} *</label>
                                        <input id="amount" name="amount" type="number" max="{{$lims_manufacturingOrder_data->amount}}" placeholder="{{trans('file.amount')}}" class="form-control numbersOnly">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{trans('file.waste')}} *</label>
                                        <input id="waste" name="waste" value="0" readonly placeholder="{{trans('file.waste')}}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{trans('file.notes')}} </label>

                                        <input type="text" name="notes"  class="form-control"  placeholder="{{trans('file.notes')}}..." >
                                    </div>

                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{trans('file.Warehouse')}} *</label>

                                        <select required id="warehouse_id" name="warehouse_id" class="form-control" data-live-search="true" data-live-search-style="begins" title="{{trans('file.Warehouse')}}...">
                                            @foreach($lims_warehouses_data as $warehouse)
                                                <option value="{{$warehouse->id}}">{{$warehouse->name??'' }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script type="text/javascript">

        $("ul#MakeProduct").siblings('a').attr('aria-expanded','true');
        $("ul#MakeProduct").addClass("show");
        $("ul#MakeProduct #manufacturingOrder-menu").addClass("active");

        $('.selectpicker').selectpicker('refresh');

    </script>

    <script>
        $('#amount').on('keyup',function (){

            var oldAmount = parseInt("{{$lims_manufacturingOrder_data->amount}}")
            if (parseInt($(this).val()) > oldAmount){
                alert('your limit is '+oldAmount)
                $(this).val(oldAmount)
                $('#waste').val(0)
                return true;
            }
                var newAmount = parseInt($(this).val())
            $('#waste').val(parseInt(oldAmount - newAmount)||0)

        })
    </script>

@endsection
