<?php $__env->startSection('content'); ?>
    <?php if($errors->has('name')): ?>
        <div class="alert alert-danger alert-dismissible text-center">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e($errors->first('name')); ?></div>
    <?php endif; ?>
    <?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('message')); ?></div>
    <?php endif; ?>
    <?php if(session()->has('not_permitted')): ?>
        <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('not_permitted')); ?></div>
    <?php endif; ?>

    <section>
        <div class="container-fluid">
            <a href="<?php echo e(route('manufacturingOrder.create')); ?>"  class="btn btn-info"><i class="dripicons-plus"></i> <?php echo e(trans('file.Add manufacturing order')); ?></a>
            
        </div>
        <div class="table-responsive">
            <table id="branch-table" class="table">
                <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th><?php echo e(trans('file.product')); ?></th>
                    <th ><?php echo e(trans('file.amount')); ?></th>
                    <th ><?php echo e(trans('file.Warehouse')); ?></th>
                    <th ><?php echo e(trans('file.notes')); ?></th>
                    <th class="not-exported"><?php echo e(trans('file.action')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $lims_manufacturingOrder_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$manufacturingOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <tr data-id="<?php echo e($manufacturingOrder->id); ?>">
                        <td><?php echo e($key); ?></td>
                        <td><?php echo e($manufacturingOrder->makeProduct->product->name??''); ?></td>
                        <td><?php echo e($manufacturingOrder->amount??''); ?></td>
                        <td><?php echo e($manufacturingOrder->warehouse->name??''); ?></td>
                        <td><?php echo e($manufacturingOrder->notes??''); ?></td>
                        
                        
                        <td>
                            <div class="btn-group">
                                <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php echo e(trans('file.action')); ?>

                                    <span class="caret"></span>
                                    <span class="sr-only">Toggle Dropdown</span>
                                </button>
                                <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                    <li>
                                        <a href="<?php echo e(route('manufacturingOrder.edit',$manufacturingOrder->id)); ?>" class="open-EditbranchDialog btn btn-link" ><i class="dripicons-document-edit"></i> <?php echo e(trans('file.end')); ?>

                                        </a>
                                    </li>
                                    <li class="divider"></li>
                                    <?php echo e(Form::open(['route' => ['manufacturingOrder.destroy', $manufacturingOrder->id], 'method' => 'DELETE'] )); ?>

                                    <li>
                                        <button type="submit" class="btn btn-link" onclick="return confirmDelete()"><i class="dripicons-trash"></i> <?php echo e(trans('file.delete')); ?></button>
                                    </li>
                                    <?php echo e(Form::close()); ?>

                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </section>


    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

    <script type="text/javascript">

        $("ul#MakeProduct").siblings('a').attr('aria-expanded','true');
        $("ul#MakeProduct").addClass("show");
        $("ul#MakeProduct #manufacturingOrder-menu").addClass("active");

        var manufacturing_id = [];
        var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        function confirmDelete() {
            if (confirm("Are you sure want to delete?")) {
                return true;
            }
            return false;
        }

        $(document).ready(function() {

            $(document).on('click', '.open-EditbranchDialog', function() {
                var url = "branch/"
                var id = $(this).data('id').toString();
                url = url.concat(id).concat("/edit");

                $.get(url, function(data) {
                    $("#editModal input[name='name']").val(data['name']);
                    $("#editModal input[name='phone']").val(data['phone']);
                    $("#editModal input[name='email']").val(data['email']);
                    $("#editModal textarea[name='address']").val(data['address']);
                    $("#editModal input[name='manufacturing_id']").val(data['id']);

                    // companySelect
                    $('#companySelect').html(data['html'])
                    $('#companySelect').selectpicker('refresh')

                });
            });
        });

        $('#branch-table').DataTable( {
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ <?php echo e(trans("file.records per page")); ?>',
                "info":      '<small><?php echo e(trans("file.Showing")); ?> _START_ - _END_ (_TOTAL_)</small>',
                "search":  '<?php echo e(trans("file.Search")); ?>',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    // 'targets': [0, 6]
                },  {
                    'render': function(data, type, row, meta){
                        if(type === 'display'){
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    'checkboxes': {
                        'selectRow': true,
                        'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                    },
                    'targets': [0]
                }
            ],
            'select': { style: 'multi',  selector: 'td:first-child'},
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'csv',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'print',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    text: '<?php echo e(trans("file.delete")); ?>',
                    className: 'buttons-delete',
                    action: function ( e, dt, node, config ) {
                        if(user_verified == '1') {
                            manufacturing_id.length = 0;
                            $(':checkbox:checked').each(function(i){
                                if(i){
                                    manufacturing_id[i-1] = $(this).closest('tr').data('id');
                                }
                            });
                            if(manufacturing_id.length && confirm("Are you sure want to delete?")) {
                                console.log(manufacturing_id)
                                $.ajax({
                                    type:'POST',
                                    url:'manufacturingOrder/deletebyselection',
                                    data:{
                                        manufacturingIdArray: manufacturing_id
                                    },
                                    success:function(data){
                                        alert(data);
                                    }
                                });
                                dt.rows({ page: 'current', selected: true }).remove().draw(false);
                            }
                            else if(!manufacturing_id.length)
                                alert('No data is selected!');
                        }
                        else
                            alert('This feature is disable for demo!');
                    }
                },
                {
                    extend: 'colvis',
                    columns: ':gt(0)'
                },
            ],
        } );

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $( "#select_all" ).on( "change", function() {
            if ($(this).is(':checked')) {
                $("tbody input[type='checkbox']").prop('checked', true);
            }
            else {
                $("tbody input[type='checkbox']").prop('checked', false);
            }
        });

        $("#export").on("click", function(e){
            e.preventDefault();
            var branch = [];
            $(':checkbox:checked').each(function(i){
                branch[i] = $(this).val();
            });
            $.ajax({
                type:'POST',
                url:'/exportbranch',
                data:{

                    branchArray: branch
                },
                success:function(data){
                    alert('Exported to CSV file successfully! Click Ok to download file');
                    window.location.href = data;
                }
            });
        });
        $('.selectpicker').selectpicker('refresh');

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u657893346/domains/kidsstation.fun/public_html/AlyasmeenPOS/resources/views/manufacturingOrder/index.blade.php ENDPATH**/ ?>