<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Floors;

class FloorsController extends Controller
{
   public function index()
   {
       $floors =  Floors::latest()->get();

       return view('floors.index',compact('floors'));
   }

   public function store(Request $request)
   {
       $date = $request->all();

       Floors::create($date);

       return redirect('floors')->with('message', 'Floor created successfully');

   }

    public function update(Request $request)
    {
        $data = $request->except('id');

        $Floors = Floors::find($request->id);

        $Floors->update($data);

        return redirect('floors')->with('message', 'Data updated successfully');
    }

    public function destroy($id)
    {
        $Floors = Floors::find($id);
        $Floors->delete();
        return redirect()->back()->with('not_permitted', 'Floors deleted successfully');

    }

}
