@extends('layout.main')
@section('content')
    @if(session()->has('message'))
        <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{!! session()->get('message') !!}</div>
    @endif
    @if(session()->has('not_permitted'))
        <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div>
    @endif

    <section>
        <div class="container-fluid">
            <button id="print-btn" type="button" class="btn btn-default btn-sm d-print-none"><i class="dripicons-print"></i> {{trans('file.Print')}}</button>
        </div>
        <div class="table-responsive">
            <div id="print">
            <table id="holiday-table" class="table">
                <tbody>
                @foreach($tables as $key =>  $table )
                    <tr>

                            <div id="print" style="float: right;width: 50%;" class="modal-body">
                                <div class="row">
                                    <div class='modal-dialog '>
                                        <div class='modal-content'>
                                            <div class='modal-header'>
                                                <h5>{{$table->name}}</h5>
                                            </div>
                                            <div id="qrc-details"  class='modal-body text-center'>
                                                <div class='visible-print text-center'>
                                                    <img src="https://chart.googleapis.com/chart?chs=300x300&cht=qr&chl={{route('menu',$table->id)}}"title="Link to Google.com"/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    </tr>
                @endforeach
                </tbody>
            </table>
            </div>
        </div>
    </section>

    <script type="text/javascript">

        $("ul#hrm").siblings('a').attr('aria-expanded','true');
        $("ul#hrm").addClass("show");
        $("ul#hrm #holiday-menu").addClass("active");

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        function confirmDelete() {
            if (confirm("Are you sure want to delete?")) {
                return true;
            }
            return false;
        }

        var holiday_id = [];
        var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;

        var date = $('.date');
        date.datepicker({
            format: "dd-mm-yyyy",
            startDate: "<?php echo date('d-m-Y'); ?>",
            autoclose: true,
            todayHighlight: true
        });

        $(document).on('click', '.btn-approve', function() {
            var id = $(this).data('id');
            $.get('approve-holiday/'+id, function(data) {
                $('.btn-approve').addClass('d-none');
            });
        });



        $('#holiday-table').DataTable( {
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
                "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
                "search":  '{{trans("file.Search")}}',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    'targets': [0, 1]
                },
            ],
            'select': { style: 'multi',  selector: 'td:first-child'},
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    text: '{{trans("file.PDF")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible',
                    }
                },
                {
                    extend: 'csv',
                    text: '{{trans("file.CSV")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible',
                    },
                },
                {
                    extend: 'print',
                    text: '{{trans("file.Print")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible',
                    },
                },
                {
                    text: '{{trans("file.delete")}}',
                    className: 'buttons-delete',
                    action: function ( e, dt, node, config ) {
                        if(user_verified == '1') {
                            holiday_id.length = 0;
                            $(':checkbox:checked').each(function(i){
                                if(i){
                                    holiday_id[i-1] = $(this).closest('tr').data('id');
                                }
                            });
                            if(holiday_id.length && confirm("Are you sure want to delete?")) {
                                $.ajax({
                                    type:'POST',
                                    url:'holidays/deletebyselection',
                                    data:{
                                        holidayIdArray: holiday_id
                                    },
                                    success:function(data){
                                        alert(data);
                                    }
                                });
                                dt.rows({ page: 'current', selected: true }).remove().draw(false);
                            }
                            else if(!holiday_id.length)
                                alert('Nothing is selected!');
                        }
                        else
                            alert('This feature is disable for demo!');
                    }
                },
                {
                    extend: 'colvis',
                    text: '{{trans("file.Column visibility")}}',
                    columns: ':gt(0)'
                },
            ],
        } );
    </script>
    <script>

        $(document).ready(function() {
            $(document).on('click', '.open-EditrewardsDialog', function() {
                var url = "table/"
                var id = $(this).data('id').toString();
                url = url.concat(id).concat("/edit");

                $.get(url, function(data) {
                    console.log(data.html)
                    $("#editModal input[name='name']").val(data['name']);
                    $("#editModal input[name='count']").val(data['count']);
                    $("#editModal input[name='id']").val(data['id']);

                    // companySelect
                    $('#doorSelect').html(data['html'])
                    $('#doorSelect').selectpicker('refresh')

                });
            });
        });

        $("#print-btn").on("click", function(){
            var divToPrint=document.getElementById('print');
            var newWin=window.open('','Print-Window');
            newWin.document.open();
            newWin.document.write('<link rel="stylesheet" href="<?php echo asset('public/vendor/bootstrap/css/bootstrap.min.css') ?>" type="text/css"><style type="text/css">@media print {.modal-dialog { max-width: 1000px;} }</style><body onload="window.print()">'+divToPrint.innerHTML+'</body>');
            newWin.document.close();
            setTimeout(function(){newWin.close();},10);
        });
    </script>
@endsection
