<?php //2c0383a1c882815fdb91030780ed3eb5
/** @noinspection all */

namespace App {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_Account_C;
    use LaravelIdea\Helper\App\_IH_Account_QB;
    use LaravelIdea\Helper\App\_IH_Adjustment_C;
    use LaravelIdea\Helper\App\_IH_Adjustment_QB;
    use LaravelIdea\Helper\App\_IH_Attendance_C;
    use LaravelIdea\Helper\App\_IH_Attendance_QB;
    use LaravelIdea\Helper\App\_IH_Biller_C;
    use LaravelIdea\Helper\App\_IH_Biller_QB;
    use LaravelIdea\Helper\App\_IH_Brand_C;
    use LaravelIdea\Helper\App\_IH_Brand_QB;
    use LaravelIdea\Helper\App\_IH_CashRegister_C;
    use LaravelIdea\Helper\App\_IH_CashRegister_QB;
    use LaravelIdea\Helper\App\_IH_Category_C;
    use LaravelIdea\Helper\App\_IH_Category_QB;
    use LaravelIdea\Helper\App\_IH_Coupon_C;
    use LaravelIdea\Helper\App\_IH_Coupon_QB;
    use LaravelIdea\Helper\App\_IH_Currency_C;
    use LaravelIdea\Helper\App\_IH_Currency_QB;
    use LaravelIdea\Helper\App\_IH_CustomerGroup_C;
    use LaravelIdea\Helper\App\_IH_CustomerGroup_QB;
    use LaravelIdea\Helper\App\_IH_Customer_C;
    use LaravelIdea\Helper\App\_IH_Customer_QB;
    use LaravelIdea\Helper\App\_IH_Delivery_C;
    use LaravelIdea\Helper\App\_IH_Delivery_QB;
    use LaravelIdea\Helper\App\_IH_Department_C;
    use LaravelIdea\Helper\App\_IH_Department_QB;
    use LaravelIdea\Helper\App\_IH_Deposit_C;
    use LaravelIdea\Helper\App\_IH_Deposit_QB;
    use LaravelIdea\Helper\App\_IH_Employee_C;
    use LaravelIdea\Helper\App\_IH_Employee_QB;
    use LaravelIdea\Helper\App\_IH_ExpenseCategory_C;
    use LaravelIdea\Helper\App\_IH_ExpenseCategory_QB;
    use LaravelIdea\Helper\App\_IH_Expense_C;
    use LaravelIdea\Helper\App\_IH_Expense_QB;
    use LaravelIdea\Helper\App\_IH_Floors_C;
    use LaravelIdea\Helper\App\_IH_Floors_QB;
    use LaravelIdea\Helper\App\_IH_GeneralSetting_C;
    use LaravelIdea\Helper\App\_IH_GeneralSetting_QB;
    use LaravelIdea\Helper\App\_IH_GiftCardRecharge_C;
    use LaravelIdea\Helper\App\_IH_GiftCardRecharge_QB;
    use LaravelIdea\Helper\App\_IH_GiftCard_C;
    use LaravelIdea\Helper\App\_IH_GiftCard_QB;
    use LaravelIdea\Helper\App\_IH_Holiday_C;
    use LaravelIdea\Helper\App\_IH_Holiday_QB;
    use LaravelIdea\Helper\App\_IH_HrmSetting_C;
    use LaravelIdea\Helper\App\_IH_HrmSetting_QB;
    use LaravelIdea\Helper\App\_IH_Language_C;
    use LaravelIdea\Helper\App\_IH_Language_QB;
    use LaravelIdea\Helper\App\_IH_MakeProductUnits_C;
    use LaravelIdea\Helper\App\_IH_MakeProductUnits_QB;
    use LaravelIdea\Helper\App\_IH_MakeProduct_C;
    use LaravelIdea\Helper\App\_IH_MakeProduct_QB;
    use LaravelIdea\Helper\App\_IH_ManufacturingOrderProducts_C;
    use LaravelIdea\Helper\App\_IH_ManufacturingOrderProducts_QB;
    use LaravelIdea\Helper\App\_IH_ManufacturingOrder_C;
    use LaravelIdea\Helper\App\_IH_ManufacturingOrder_QB;
    use LaravelIdea\Helper\App\_IH_MoneyTransfer_C;
    use LaravelIdea\Helper\App\_IH_MoneyTransfer_QB;
    use LaravelIdea\Helper\App\_IH_PaymentWithCheque_C;
    use LaravelIdea\Helper\App\_IH_PaymentWithCheque_QB;
    use LaravelIdea\Helper\App\_IH_PaymentWithCreditCard_C;
    use LaravelIdea\Helper\App\_IH_PaymentWithCreditCard_QB;
    use LaravelIdea\Helper\App\_IH_PaymentWithGiftCard_C;
    use LaravelIdea\Helper\App\_IH_PaymentWithGiftCard_QB;
    use LaravelIdea\Helper\App\_IH_PaymentWithPaypal_C;
    use LaravelIdea\Helper\App\_IH_PaymentWithPaypal_QB;
    use LaravelIdea\Helper\App\_IH_Payment_C;
    use LaravelIdea\Helper\App\_IH_Payment_QB;
    use LaravelIdea\Helper\App\_IH_Payroll_C;
    use LaravelIdea\Helper\App\_IH_Payroll_QB;
    use LaravelIdea\Helper\App\_IH_PosSetting_C;
    use LaravelIdea\Helper\App\_IH_PosSetting_QB;
    use LaravelIdea\Helper\App\_IH_ProductAdjustment_C;
    use LaravelIdea\Helper\App\_IH_ProductAdjustment_QB;
    use LaravelIdea\Helper\App\_IH_ProductBatch_C;
    use LaravelIdea\Helper\App\_IH_ProductBatch_QB;
    use LaravelIdea\Helper\App\_IH_ProductionUnit_C;
    use LaravelIdea\Helper\App\_IH_ProductionUnit_QB;
    use LaravelIdea\Helper\App\_IH_ProductPurchase_C;
    use LaravelIdea\Helper\App\_IH_ProductPurchase_QB;
    use LaravelIdea\Helper\App\_IH_ProductQuotation_C;
    use LaravelIdea\Helper\App\_IH_ProductQuotation_QB;
    use LaravelIdea\Helper\App\_IH_ProductReturn_C;
    use LaravelIdea\Helper\App\_IH_ProductReturn_QB;
    use LaravelIdea\Helper\App\_IH_ProductTransfer_C;
    use LaravelIdea\Helper\App\_IH_ProductTransfer_QB;
    use LaravelIdea\Helper\App\_IH_ProductVariant_C;
    use LaravelIdea\Helper\App\_IH_ProductVariant_QB;
    use LaravelIdea\Helper\App\_IH_Product_C;
    use LaravelIdea\Helper\App\_IH_Product_QB;
    use LaravelIdea\Helper\App\_IH_Product_Sale_C;
    use LaravelIdea\Helper\App\_IH_Product_Sale_QB;
    use LaravelIdea\Helper\App\_IH_Product_Supplier_C;
    use LaravelIdea\Helper\App\_IH_Product_Supplier_QB;
    use LaravelIdea\Helper\App\_IH_Product_Warehouse_C;
    use LaravelIdea\Helper\App\_IH_Product_Warehouse_QB;
    use LaravelIdea\Helper\App\_IH_PurchaseProductReturn_C;
    use LaravelIdea\Helper\App\_IH_PurchaseProductReturn_QB;
    use LaravelIdea\Helper\App\_IH_Purchase_C;
    use LaravelIdea\Helper\App\_IH_Purchase_QB;
    use LaravelIdea\Helper\App\_IH_Quotation_C;
    use LaravelIdea\Helper\App\_IH_Quotation_QB;
    use LaravelIdea\Helper\App\_IH_ReturnPurchase_C;
    use LaravelIdea\Helper\App\_IH_ReturnPurchase_QB;
    use LaravelIdea\Helper\App\_IH_Returns_C;
    use LaravelIdea\Helper\App\_IH_Returns_QB;
    use LaravelIdea\Helper\App\_IH_RewardPointSetting_C;
    use LaravelIdea\Helper\App\_IH_RewardPointSetting_QB;
    use LaravelIdea\Helper\App\_IH_Roles_C;
    use LaravelIdea\Helper\App\_IH_Roles_QB;
    use LaravelIdea\Helper\App\_IH_Sale_C;
    use LaravelIdea\Helper\App\_IH_Sale_QB;
    use LaravelIdea\Helper\App\_IH_StockCount_C;
    use LaravelIdea\Helper\App\_IH_StockCount_QB;
    use LaravelIdea\Helper\App\_IH_Supplier_C;
    use LaravelIdea\Helper\App\_IH_Supplier_QB;
    use LaravelIdea\Helper\App\_IH_Tables_C;
    use LaravelIdea\Helper\App\_IH_Tables_QB;
    use LaravelIdea\Helper\App\_IH_Tax_C;
    use LaravelIdea\Helper\App\_IH_Tax_QB;
    use LaravelIdea\Helper\App\_IH_Transfer_C;
    use LaravelIdea\Helper\App\_IH_Transfer_QB;
    use LaravelIdea\Helper\App\_IH_Unit_C;
    use LaravelIdea\Helper\App\_IH_Unit_QB;
    use LaravelIdea\Helper\App\_IH_User_C;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\App\_IH_Variant_C;
    use LaravelIdea\Helper\App\_IH_Variant_QB;
    use LaravelIdea\Helper\App\_IH_Warehouse_C;
    use LaravelIdea\Helper\App\_IH_Warehouse_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;

    /**
     * @property int $id
     * @property string $account_no
     * @property string $name
     * @property float|null $initial_balance
     * @property float $total_balance
     * @property string|null $note
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool|null $is_default
     * @method static _IH_Account_QB onWriteConnection()
     * @method _IH_Account_QB newQuery()
     * @method static _IH_Account_QB on(null|string $connection = null)
     * @method static _IH_Account_QB query()
     * @method static _IH_Account_QB with(array|string $relations)
     * @method _IH_Account_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Account_C|Account[] all()
     * @foreignLinks id,\App\Payment,account_id|id,\App\Returns,account_id|id,\App\Expense,account_id|id,\App\ReturnPurchase,account_id|id,\App\Payroll,account_id
     * @mixin _IH_Account_QB
     */
    class Account extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $warehouse_id
     * @property string|null $document
     * @property float $total_qty
     * @property int $item
     * @property string|null $note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Adjustment_QB onWriteConnection()
     * @method _IH_Adjustment_QB newQuery()
     * @method static _IH_Adjustment_QB on(null|string $connection = null)
     * @method static _IH_Adjustment_QB query()
     * @method static _IH_Adjustment_QB with(array|string $relations)
     * @method _IH_Adjustment_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Adjustment_C|Adjustment[] all()
     * @ownLinks warehouse_id,\App\Warehouse,id
     * @foreignLinks id,\App\ProductAdjustment,adjustment_id
     * @mixin _IH_Adjustment_QB
     */
    class Adjustment extends Model {}

    /**
     * @property int $id
     * @property Carbon $date
     * @property int $employee_id
     * @property int $user_id
     * @property string $checkin
     * @property string $checkout
     * @property int $status
     * @property string|null $note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Attendance_QB onWriteConnection()
     * @method _IH_Attendance_QB newQuery()
     * @method static _IH_Attendance_QB on(null|string $connection = null)
     * @method static _IH_Attendance_QB query()
     * @method static _IH_Attendance_QB with(array|string $relations)
     * @method _IH_Attendance_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Attendance_C|Attendance[] all()
     * @ownLinks employee_id,\App\Employee,id|user_id,\App\User,id
     * @mixin _IH_Attendance_QB
     */
    class Attendance extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string|null $image
     * @property string $company_name
     * @property string|null $vat_number
     * @property string $email
     * @property string $phone_number
     * @property string $address
     * @property string $city
     * @property string|null $state
     * @property string|null $postal_code
     * @property string|null $country
     * @property bool|null $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Sale_C|Sale[] $sale
     * @property-read int $sale_count
     * @method HasMany|_IH_Sale_QB sale()
     * @method static _IH_Biller_QB onWriteConnection()
     * @method _IH_Biller_QB newQuery()
     * @method static _IH_Biller_QB on(null|string $connection = null)
     * @method static _IH_Biller_QB query()
     * @method static _IH_Biller_QB with(array|string $relations)
     * @method _IH_Biller_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Biller_C|Biller[] all()
     * @foreignLinks id,\App\User,biller_id|id,\App\Sale,biller_id|id,\App\Quotation,biller_id|id,\App\Returns,biller_id|id,\App\PosSetting,biller_id
     * @mixin _IH_Biller_QB
     */
    class Biller extends Model {}

    /**
     * @property int $id
     * @property string $title
     * @property string|null $image
     * @property bool|null $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Brand_QB onWriteConnection()
     * @method _IH_Brand_QB newQuery()
     * @method static _IH_Brand_QB on(null|string $connection = null)
     * @method static _IH_Brand_QB query()
     * @method static _IH_Brand_QB with(array|string $relations)
     * @method _IH_Brand_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Brand_C|Brand[] all()
     * @foreignLinks id,\App\Product,brand_id|id,\App\StockCount,brand_id
     * @mixin _IH_Brand_QB
     */
    class Brand extends Model {}

    /**
     * @property int $id
     * @property float $cash_in_hand
     * @property int $user_id
     * @property int $warehouse_id
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property Warehouse $warehouse
     * @method BelongsTo|_IH_Warehouse_QB warehouse()
     * @method static _IH_CashRegister_QB onWriteConnection()
     * @method _IH_CashRegister_QB newQuery()
     * @method static _IH_CashRegister_QB on(null|string $connection = null)
     * @method static _IH_CashRegister_QB query()
     * @method static _IH_CashRegister_QB with(array|string $relations)
     * @method _IH_CashRegister_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CashRegister_C|CashRegister[] all()
     * @ownLinks user_id,\App\User,id|warehouse_id,\App\Warehouse,id
     * @foreignLinks id,\App\Sale,cash_register_id|id,\App\Payment,cash_register_id|id,\App\Returns,cash_register_id|id,\App\Expense,cash_register_id
     * @mixin _IH_CashRegister_QB
     */
    class CashRegister extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property int|null $parent_id
     * @property bool|null $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $image
     * @property _IH_Product_C|Product[] $product
     * @property-read int $product_count
     * @method HasMany|_IH_Product_QB product()
     * @method static _IH_Category_QB onWriteConnection()
     * @method _IH_Category_QB newQuery()
     * @method static _IH_Category_QB on(null|string $connection = null)
     * @method static _IH_Category_QB query()
     * @method static _IH_Category_QB with(array|string $relations)
     * @method _IH_Category_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Category_C|Category[] all()
     * @foreignLinks id,\App\Product,category_id|id,\App\StockCount,category_id
     * @mixin _IH_Category_QB
     */
    class Category extends Model {}

    /**
     * @property int $id
     * @property string $code
     * @property string $type
     * @property float $amount
     * @property float|null $minimum_amount
     * @property int $quantity
     * @property int $used
     * @property Carbon $expired_date
     * @property int $user_id
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Coupon_QB onWriteConnection()
     * @method _IH_Coupon_QB newQuery()
     * @method static _IH_Coupon_QB on(null|string $connection = null)
     * @method static _IH_Coupon_QB query()
     * @method static _IH_Coupon_QB with(array|string $relations)
     * @method _IH_Coupon_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Coupon_C|Coupon[] all()
     * @ownLinks user_id,\App\User,id
     * @foreignLinks id,\App\Sale,coupon_id
     * @mixin _IH_Coupon_QB
     */
    class Coupon extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $code
     * @property float $exchange_rate
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Currency_QB onWriteConnection()
     * @method _IH_Currency_QB newQuery()
     * @method static _IH_Currency_QB on(null|string $connection = null)
     * @method static _IH_Currency_QB query()
     * @method static _IH_Currency_QB with(array|string $relations)
     * @method _IH_Currency_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Currency_C|Currency[] all()
     * @mixin _IH_Currency_QB
     */
    class Currency extends Model {}

    /**
     * @property int $id
     * @property int $customer_group_id
     * @property string $name
     * @property string|null $company_name
     * @property string|null $email
     * @property string $phone_number
     * @property string $address
     * @property string $city
     * @property string|null $state
     * @property string|null $postal_code
     * @property string|null $country
     * @property bool|null $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property float|null $deposit
     * @property float|null $expense
     * @property string|null $tax_no
     * @property int|null $user_id
     * @property float|null $points
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Customer_QB onWriteConnection()
     * @method _IH_Customer_QB newQuery()
     * @method static _IH_Customer_QB on(null|string $connection = null)
     * @method static _IH_Customer_QB query()
     * @method static _IH_Customer_QB with(array|string $relations)
     * @method _IH_Customer_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Customer_C|Customer[] all()
     * @ownLinks customer_group_id,\App\CustomerGroup,id|user_id,\App\User,id
     * @foreignLinks id,\App\Sale,customer_id|id,\App\PaymentWithCreditCard,customer_id|id,\App\Quotation,customer_id|id,\App\Returns,customer_id|id,\App\PosSetting,customer_id|id,\App\GiftCard,customer_id|id,\App\Deposit,customer_id
     * @mixin _IH_Customer_QB
     */
    class Customer extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $percentage
     * @property bool|null $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CustomerGroup_QB onWriteConnection()
     * @method _IH_CustomerGroup_QB newQuery()
     * @method static _IH_CustomerGroup_QB on(null|string $connection = null)
     * @method static _IH_CustomerGroup_QB query()
     * @method static _IH_CustomerGroup_QB with(array|string $relations)
     * @method _IH_CustomerGroup_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CustomerGroup_C|CustomerGroup[] all()
     * @foreignLinks id,\App\Customer,customer_group_id
     * @mixin _IH_CustomerGroup_QB
     */
    class CustomerGroup extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $sale_id
     * @property string $address
     * @property string|null $delivered_by
     * @property string|null $recieved_by
     * @property string|null $file
     * @property string|null $note
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $user_id
     * @property Sale $sale
     * @method BelongsTo|_IH_Sale_QB sale()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Delivery_QB onWriteConnection()
     * @method _IH_Delivery_QB newQuery()
     * @method static _IH_Delivery_QB on(null|string $connection = null)
     * @method static _IH_Delivery_QB query()
     * @method static _IH_Delivery_QB with(array|string $relations)
     * @method _IH_Delivery_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Delivery_C|Delivery[] all()
     * @ownLinks sale_id,\App\Sale,id|user_id,\App\User,id
     * @mixin _IH_Delivery_QB
     */
    class Delivery extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Department_QB onWriteConnection()
     * @method _IH_Department_QB newQuery()
     * @method static _IH_Department_QB on(null|string $connection = null)
     * @method static _IH_Department_QB query()
     * @method static _IH_Department_QB with(array|string $relations)
     * @method _IH_Department_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Department_C|Department[] all()
     * @foreignLinks id,\App\Employee,department_id
     * @mixin _IH_Department_QB
     */
    class Department extends Model {}

    /**
     * @property int $id
     * @property float $amount
     * @property int $customer_id
     * @property int $user_id
     * @property string|null $note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Deposit_QB onWriteConnection()
     * @method _IH_Deposit_QB newQuery()
     * @method static _IH_Deposit_QB on(null|string $connection = null)
     * @method static _IH_Deposit_QB query()
     * @method static _IH_Deposit_QB with(array|string $relations)
     * @method _IH_Deposit_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Deposit_C|Deposit[] all()
     * @ownLinks customer_id,\App\Customer,id|user_id,\App\User,id
     * @mixin _IH_Deposit_QB
     */
    class Deposit extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property string $phone_number
     * @property int|null $user_id
     * @property string|null $image
     * @property string|null $address
     * @property string|null $city
     * @property string|null $country
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $department_id
     * @property _IH_Payroll_C|Payroll[] $payroll
     * @property-read int $payroll_count
     * @method HasMany|_IH_Payroll_QB payroll()
     * @method static _IH_Employee_QB onWriteConnection()
     * @method _IH_Employee_QB newQuery()
     * @method static _IH_Employee_QB on(null|string $connection = null)
     * @method static _IH_Employee_QB query()
     * @method static _IH_Employee_QB with(array|string $relations)
     * @method _IH_Employee_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Employee_C|Employee[] all()
     * @ownLinks user_id,\App\User,id|department_id,\App\Department,id
     * @foreignLinks id,\App\Payroll,employee_id|id,\App\Attendance,employee_id
     * @mixin _IH_Employee_QB
     */
    class Employee extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $expense_category_id
     * @property int $warehouse_id
     * @property float $amount
     * @property string|null $note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $account_id
     * @property int $user_id
     * @property int|null $cash_register_id
     * @property ExpenseCategory $expenseCategory
     * @method BelongsTo|_IH_ExpenseCategory_QB expenseCategory()
     * @property Warehouse $warehouse
     * @method BelongsTo|_IH_Warehouse_QB warehouse()
     * @method static _IH_Expense_QB onWriteConnection()
     * @method _IH_Expense_QB newQuery()
     * @method static _IH_Expense_QB on(null|string $connection = null)
     * @method static _IH_Expense_QB query()
     * @method static _IH_Expense_QB with(array|string $relations)
     * @method _IH_Expense_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Expense_C|Expense[] all()
     * @ownLinks expense_category_id,\App\ExpenseCategory,id|warehouse_id,\App\Warehouse,id|account_id,\App\Account,id|user_id,\App\User,id|cash_register_id,\App\CashRegister,id
     * @mixin _IH_Expense_QB
     */
    class Expense extends Model {}

    /**
     * @property int $id
     * @property string $code
     * @property string $name
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Expense_C|Expense[] $expense
     * @property-read int $expense_count
     * @method HasMany|_IH_Expense_QB expense()
     * @method static _IH_ExpenseCategory_QB onWriteConnection()
     * @method _IH_ExpenseCategory_QB newQuery()
     * @method static _IH_ExpenseCategory_QB on(null|string $connection = null)
     * @method static _IH_ExpenseCategory_QB query()
     * @method static _IH_ExpenseCategory_QB with(array|string $relations)
     * @method _IH_ExpenseCategory_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ExpenseCategory_C|ExpenseCategory[] all()
     * @foreignLinks id,\App\Expense,expense_category_id
     * @mixin _IH_ExpenseCategory_QB
     */
    class ExpenseCategory extends Model {}

    /**
     * @method static _IH_Floors_QB onWriteConnection()
     * @method _IH_Floors_QB newQuery()
     * @method static _IH_Floors_QB on(null|string $connection = null)
     * @method static _IH_Floors_QB query()
     * @method static _IH_Floors_QB with(array|string $relations)
     * @method _IH_Floors_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Floors_C|Floors[] all()
     * @mixin _IH_Floors_QB
     */
    class Floors extends Model {}

    /**
     * @property int $id
     * @property string $site_title
     * @property string|null $site_logo
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $currency
     * @property string $currency_position
     * @property string $staff_access
     * @property string $date_format
     * @property string $theme
     * @property string|null $developed_by
     * @property string|null $invoice_format
     * @property int|null $state
     * @property bool|null $is_rtl
     * @method static _IH_GeneralSetting_QB onWriteConnection()
     * @method _IH_GeneralSetting_QB newQuery()
     * @method static _IH_GeneralSetting_QB on(null|string $connection = null)
     * @method static _IH_GeneralSetting_QB query()
     * @method static _IH_GeneralSetting_QB with(array|string $relations)
     * @method _IH_GeneralSetting_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GeneralSetting_C|GeneralSetting[] all()
     * @mixin _IH_GeneralSetting_QB
     */
    class GeneralSetting extends Model {}

    /**
     * @property int $id
     * @property string $card_no
     * @property float $amount
     * @property float $expense
     * @property int|null $customer_id
     * @property int|null $user_id
     * @property Carbon|null $expired_date
     * @property int $created_by
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_GiftCard_QB onWriteConnection()
     * @method _IH_GiftCard_QB newQuery()
     * @method static _IH_GiftCard_QB on(null|string $connection = null)
     * @method static _IH_GiftCard_QB query()
     * @method static _IH_GiftCard_QB with(array|string $relations)
     * @method _IH_GiftCard_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GiftCard_C|GiftCard[] all()
     * @ownLinks customer_id,\App\Customer,id|user_id,\App\User,id
     * @foreignLinks id,\App\PaymentWithGiftCard,gift_card_id|id,\App\GiftCardRecharge,gift_card_id
     * @mixin _IH_GiftCard_QB
     */
    class GiftCard extends Model {}

    /**
     * @property int $id
     * @property int $gift_card_id
     * @property float $amount
     * @property int $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_GiftCardRecharge_QB onWriteConnection()
     * @method _IH_GiftCardRecharge_QB newQuery()
     * @method static _IH_GiftCardRecharge_QB on(null|string $connection = null)
     * @method static _IH_GiftCardRecharge_QB query()
     * @method static _IH_GiftCardRecharge_QB with(array|string $relations)
     * @method _IH_GiftCardRecharge_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GiftCardRecharge_C|GiftCardRecharge[] all()
     * @ownLinks gift_card_id,\App\GiftCard,id|user_id,\App\User,id
     * @mixin _IH_GiftCardRecharge_QB
     */
    class GiftCardRecharge extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property Carbon $from_date
     * @property Carbon $to_date
     * @property string|null $note
     * @property bool $is_approved
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Holiday_QB onWriteConnection()
     * @method _IH_Holiday_QB newQuery()
     * @method static _IH_Holiday_QB on(null|string $connection = null)
     * @method static _IH_Holiday_QB query()
     * @method static _IH_Holiday_QB with(array|string $relations)
     * @method _IH_Holiday_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Holiday_C|Holiday[] all()
     * @ownLinks user_id,\App\User,id
     * @mixin _IH_Holiday_QB
     */
    class Holiday extends Model {}

    /**
     * @property int $id
     * @property string $checkin
     * @property string $checkout
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_HrmSetting_QB onWriteConnection()
     * @method _IH_HrmSetting_QB newQuery()
     * @method static _IH_HrmSetting_QB on(null|string $connection = null)
     * @method static _IH_HrmSetting_QB query()
     * @method static _IH_HrmSetting_QB with(array|string $relations)
     * @method _IH_HrmSetting_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_HrmSetting_C|HrmSetting[] all()
     * @mixin _IH_HrmSetting_QB
     */
    class HrmSetting extends Model {}

    /**
     * @property int $id
     * @property string $code
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Language_QB onWriteConnection()
     * @method _IH_Language_QB newQuery()
     * @method static _IH_Language_QB on(null|string $connection = null)
     * @method static _IH_Language_QB query()
     * @method static _IH_Language_QB with(array|string $relations)
     * @method _IH_Language_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Language_C|Language[] all()
     * @mixin _IH_Language_QB
     */
    class Language extends Model {}

    /**
     * @property _IH_MakeProductUnits_C|MakeProductUnits[] $child
     * @property-read int $child_count
     * @method HasMany|_IH_MakeProductUnits_QB child()
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @method static _IH_MakeProduct_QB onWriteConnection()
     * @method _IH_MakeProduct_QB newQuery()
     * @method static _IH_MakeProduct_QB on(null|string $connection = null)
     * @method static _IH_MakeProduct_QB query()
     * @method static _IH_MakeProduct_QB with(array|string $relations)
     * @method _IH_MakeProduct_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MakeProduct_C|MakeProduct[] all()
     * @mixin _IH_MakeProduct_QB
     */
    class MakeProduct extends Model {}

    /**
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @property Unit $unit
     * @method BelongsTo|_IH_Unit_QB unit()
     * @method static _IH_MakeProductUnits_QB onWriteConnection()
     * @method _IH_MakeProductUnits_QB newQuery()
     * @method static _IH_MakeProductUnits_QB on(null|string $connection = null)
     * @method static _IH_MakeProductUnits_QB query()
     * @method static _IH_MakeProductUnits_QB with(array|string $relations)
     * @method _IH_MakeProductUnits_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MakeProductUnits_C|MakeProductUnits[] all()
     * @mixin _IH_MakeProductUnits_QB
     */
    class MakeProductUnits extends Model {}

    /**
     * @property MakeProduct $makeProduct
     * @method BelongsTo|_IH_MakeProduct_QB makeProduct()
     * @property Warehouse $warehouse
     * @method BelongsTo|_IH_Warehouse_QB warehouse()
     * @method static _IH_ManufacturingOrder_QB onWriteConnection()
     * @method _IH_ManufacturingOrder_QB newQuery()
     * @method static _IH_ManufacturingOrder_QB on(null|string $connection = null)
     * @method static _IH_ManufacturingOrder_QB query()
     * @method static _IH_ManufacturingOrder_QB with(array|string $relations)
     * @method _IH_ManufacturingOrder_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ManufacturingOrder_C|ManufacturingOrder[] all()
     * @mixin _IH_ManufacturingOrder_QB
     */
    class ManufacturingOrder extends Model {}

    /**
     * @method static _IH_ManufacturingOrderProducts_QB onWriteConnection()
     * @method _IH_ManufacturingOrderProducts_QB newQuery()
     * @method static _IH_ManufacturingOrderProducts_QB on(null|string $connection = null)
     * @method static _IH_ManufacturingOrderProducts_QB query()
     * @method static _IH_ManufacturingOrderProducts_QB with(array|string $relations)
     * @method _IH_ManufacturingOrderProducts_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ManufacturingOrderProducts_C|ManufacturingOrderProducts[] all()
     * @mixin _IH_ManufacturingOrderProducts_QB
     */
    class ManufacturingOrderProducts extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $from_account_id
     * @property int $to_account_id
     * @property float $amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Account $fromAccount
     * @method BelongsTo|_IH_Account_QB fromAccount()
     * @property Account $toAccount
     * @method BelongsTo|_IH_Account_QB toAccount()
     * @method static _IH_MoneyTransfer_QB onWriteConnection()
     * @method _IH_MoneyTransfer_QB newQuery()
     * @method static _IH_MoneyTransfer_QB on(null|string $connection = null)
     * @method static _IH_MoneyTransfer_QB query()
     * @method static _IH_MoneyTransfer_QB with(array|string $relations)
     * @method _IH_MoneyTransfer_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MoneyTransfer_C|MoneyTransfer[] all()
     * @mixin _IH_MoneyTransfer_QB
     */
    class MoneyTransfer extends Model {}

    /**
     * @property int $id
     * @property int|null $sale_id
     * @property string $payment_reference
     * @property float $amount
     * @property string $paying_method
     * @property string|null $payment_note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $purchase_id
     * @property int $user_id
     * @property int $account_id
     * @property int|null $cash_register_id
     * @property float|null $used_points
     * @method static _IH_Payment_QB onWriteConnection()
     * @method _IH_Payment_QB newQuery()
     * @method static _IH_Payment_QB on(null|string $connection = null)
     * @method static _IH_Payment_QB query()
     * @method static _IH_Payment_QB with(array|string $relations)
     * @method _IH_Payment_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Payment_C|Payment[] all()
     * @ownLinks sale_id,\App\Sale,id|purchase_id,\App\Purchase,id|user_id,\App\User,id|account_id,\App\Account,id|cash_register_id,\App\CashRegister,id
     * @foreignLinks id,\App\PaymentWithCheque,payment_id|id,\App\PaymentWithCreditCard,payment_id|id,\App\PaymentWithGiftCard,payment_id|id,\App\PaymentWithPaypal,payment_id
     * @mixin _IH_Payment_QB
     */
    class Payment extends Model {}

    /**
     * @property int $id
     * @property int $payment_id
     * @property string $cheque_no
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PaymentWithCheque_QB onWriteConnection()
     * @method _IH_PaymentWithCheque_QB newQuery()
     * @method static _IH_PaymentWithCheque_QB on(null|string $connection = null)
     * @method static _IH_PaymentWithCheque_QB query()
     * @method static _IH_PaymentWithCheque_QB with(array|string $relations)
     * @method _IH_PaymentWithCheque_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentWithCheque_C|PaymentWithCheque[] all()
     * @ownLinks payment_id,\App\Payment,id
     * @mixin _IH_PaymentWithCheque_QB
     */
    class PaymentWithCheque extends Model {}

    /**
     * @property int $id
     * @property int $payment_id
     * @property int|null $customer_id
     * @property string|null $customer_stripe_id
     * @property string $charge_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PaymentWithCreditCard_QB onWriteConnection()
     * @method _IH_PaymentWithCreditCard_QB newQuery()
     * @method static _IH_PaymentWithCreditCard_QB on(null|string $connection = null)
     * @method static _IH_PaymentWithCreditCard_QB query()
     * @method static _IH_PaymentWithCreditCard_QB with(array|string $relations)
     * @method _IH_PaymentWithCreditCard_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentWithCreditCard_C|PaymentWithCreditCard[] all()
     * @ownLinks payment_id,\App\Payment,id|customer_id,\App\Customer,id
     * @mixin _IH_PaymentWithCreditCard_QB
     */
    class PaymentWithCreditCard extends Model {}

    /**
     * @property int $id
     * @property int $payment_id
     * @property int $gift_card_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PaymentWithGiftCard_QB onWriteConnection()
     * @method _IH_PaymentWithGiftCard_QB newQuery()
     * @method static _IH_PaymentWithGiftCard_QB on(null|string $connection = null)
     * @method static _IH_PaymentWithGiftCard_QB query()
     * @method static _IH_PaymentWithGiftCard_QB with(array|string $relations)
     * @method _IH_PaymentWithGiftCard_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentWithGiftCard_C|PaymentWithGiftCard[] all()
     * @ownLinks payment_id,\App\Payment,id|gift_card_id,\App\GiftCard,id
     * @mixin _IH_PaymentWithGiftCard_QB
     */
    class PaymentWithGiftCard extends Model {}

    /**
     * @property int $id
     * @property int $payment_id
     * @property string $transaction_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PaymentWithPaypal_QB onWriteConnection()
     * @method _IH_PaymentWithPaypal_QB newQuery()
     * @method static _IH_PaymentWithPaypal_QB on(null|string $connection = null)
     * @method static _IH_PaymentWithPaypal_QB query()
     * @method static _IH_PaymentWithPaypal_QB with(array|string $relations)
     * @method _IH_PaymentWithPaypal_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentWithPaypal_C|PaymentWithPaypal[] all()
     * @ownLinks payment_id,\App\Payment,id
     * @mixin _IH_PaymentWithPaypal_QB
     */
    class PaymentWithPaypal extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $employee_id
     * @property int $account_id
     * @property int $user_id
     * @property float $amount
     * @property string $paying_method
     * @property string|null $note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Employee $employee
     * @method BelongsTo|_IH_Employee_QB employee()
     * @method static _IH_Payroll_QB onWriteConnection()
     * @method _IH_Payroll_QB newQuery()
     * @method static _IH_Payroll_QB on(null|string $connection = null)
     * @method static _IH_Payroll_QB query()
     * @method static _IH_Payroll_QB with(array|string $relations)
     * @method _IH_Payroll_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Payroll_C|Payroll[] all()
     * @ownLinks employee_id,\App\Employee,id|account_id,\App\Account,id|user_id,\App\User,id
     * @mixin _IH_Payroll_QB
     */
    class Payroll extends Model {}

    /**
     * @property int $id
     * @property int $customer_id
     * @property int $warehouse_id
     * @property int $biller_id
     * @property int $product_number
     * @property string|null $stripe_public_key
     * @property string $stripe_secret_key
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool $keybord_active
     * @method static _IH_PosSetting_QB onWriteConnection()
     * @method _IH_PosSetting_QB newQuery()
     * @method static _IH_PosSetting_QB on(null|string $connection = null)
     * @method static _IH_PosSetting_QB query()
     * @method static _IH_PosSetting_QB with(array|string $relations)
     * @method _IH_PosSetting_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PosSetting_C|PosSetting[] all()
     * @ownLinks customer_id,\App\Customer,id|warehouse_id,\App\Warehouse,id|biller_id,\App\Biller,id
     * @mixin _IH_PosSetting_QB
     */
    class PosSetting extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $code
     * @property string $type
     * @property string $barcode_symbology
     * @property int|null $brand_id
     * @property int $category_id
     * @property int $unit_id
     * @property int $purchase_unit_id
     * @property int $sale_unit_id
     * @property string $cost
     * @property string $price
     * @property float|null $qty
     * @property float|null $alert_quantity
     * @property int|null $promotion
     * @property string|null $promotion_price
     * @property Carbon|null $starting_date
     * @property Carbon|null $last_date
     * @property int|null $tax_id
     * @property int|null $tax_method
     * @property string|null $image
     * @property int|null $featured
     * @property string|null $product_details
     * @property bool|null $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $file
     * @property string|null $product_list
     * @property string|null $qty_list
     * @property string|null $price_list
     * @property bool|null $is_variant
     * @property bool|null $is_diffPrice
     * @property bool|null $is_batch
     * @property string|null $variant_list
     * @property bool|null $is_imei
     * @property Brand|null $brand
     * @method BelongsTo|_IH_Brand_QB brand()
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property Unit $unit
     * @method BelongsTo|_IH_Unit_QB unit()
     * @property _IH_Variant_C|Variant[] $variant
     * @property-read int $variant_count
     * @method BelongsToMany|_IH_Variant_QB variant()
     * @method static _IH_Product_QB onWriteConnection()
     * @method _IH_Product_QB newQuery()
     * @method static _IH_Product_QB on(null|string $connection = null)
     * @method static _IH_Product_QB query()
     * @method static _IH_Product_QB with(array|string $relations)
     * @method _IH_Product_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Product_C|Product[] all()
     * @ownLinks brand_id,\App\Brand,id|category_id,\App\Category,id|unit_id,\App\Unit,id|tax_id,\App\Tax,id
     * @foreignLinks id,\App\ProductPurchase,product_id|id,\App\Product_Warehouse,product_id|id,\App\Product_Sale,product_id|id,\App\ProductQuotation,product_id|id,\App\ProductTransfer,product_id|id,\App\ProductAdjustment,product_id|id,\App\ProductReturn,product_id|id,\App\PurchaseProductReturn,product_id|id,\App\ProductVariant,product_id|id,\App\ProductBatch,product_id
     * @mixin _IH_Product_QB
     */
    class Product extends Model {}

    /**
     * @property int $id
     * @property int $adjustment_id
     * @property int $product_id
     * @property float $qty
     * @property string $action
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $variant_id
     * @method static _IH_ProductAdjustment_QB onWriteConnection()
     * @method _IH_ProductAdjustment_QB newQuery()
     * @method static _IH_ProductAdjustment_QB on(null|string $connection = null)
     * @method static _IH_ProductAdjustment_QB query()
     * @method static _IH_ProductAdjustment_QB with(array|string $relations)
     * @method _IH_ProductAdjustment_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductAdjustment_C|ProductAdjustment[] all()
     * @ownLinks adjustment_id,\App\Adjustment,id|product_id,\App\Product,id|variant_id,\App\Variant,id
     * @mixin _IH_ProductAdjustment_QB
     */
    class ProductAdjustment extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property string $batch_no
     * @property Carbon $expired_date
     * @property float $qty
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ProductBatch_QB onWriteConnection()
     * @method _IH_ProductBatch_QB newQuery()
     * @method static _IH_ProductBatch_QB on(null|string $connection = null)
     * @method static _IH_ProductBatch_QB query()
     * @method static _IH_ProductBatch_QB with(array|string $relations)
     * @method _IH_ProductBatch_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductBatch_C|ProductBatch[] all()
     * @ownLinks product_id,\App\Product,id
     * @foreignLinks id,\App\ProductPurchase,product_batch_id|id,\App\Product_Warehouse,product_batch_id|id,\App\Product_Sale,product_batch_id|id,\App\ProductQuotation,product_batch_id|id,\App\ProductTransfer,product_batch_id|id,\App\ProductReturn,product_batch_id|id,\App\PurchaseProductReturn,product_batch_id
     * @mixin _IH_ProductBatch_QB
     */
    class ProductBatch extends Model {}

    /**
     * @property int $id
     * @property int $purchase_id
     * @property int $product_id
     * @property float $qty
     * @property float $recieved
     * @property int $purchase_unit_id
     * @property float $net_unit_cost
     * @property float $discount
     * @property float $tax_rate
     * @property float $tax
     * @property float $total
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $variant_id
     * @property int|null $product_batch_id
     * @property string|null $imei_number
     * @method static _IH_ProductPurchase_QB onWriteConnection()
     * @method _IH_ProductPurchase_QB newQuery()
     * @method static _IH_ProductPurchase_QB on(null|string $connection = null)
     * @method static _IH_ProductPurchase_QB query()
     * @method static _IH_ProductPurchase_QB with(array|string $relations)
     * @method _IH_ProductPurchase_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductPurchase_C|ProductPurchase[] all()
     * @ownLinks purchase_id,\App\Purchase,id|product_id,\App\Product,id|variant_id,\App\Variant,id|product_batch_id,\App\ProductBatch,id
     * @mixin _IH_ProductPurchase_QB
     */
    class ProductPurchase extends Model {}

    /**
     * @property int $id
     * @property int $quotation_id
     * @property int $product_id
     * @property float $qty
     * @property int $sale_unit_id
     * @property float $net_unit_price
     * @property float $discount
     * @property float $tax_rate
     * @property float $tax
     * @property float $total
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $variant_id
     * @property int|null $product_batch_id
     * @method static _IH_ProductQuotation_QB onWriteConnection()
     * @method _IH_ProductQuotation_QB newQuery()
     * @method static _IH_ProductQuotation_QB on(null|string $connection = null)
     * @method static _IH_ProductQuotation_QB query()
     * @method static _IH_ProductQuotation_QB with(array|string $relations)
     * @method _IH_ProductQuotation_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductQuotation_C|ProductQuotation[] all()
     * @ownLinks quotation_id,\App\Quotation,id|product_id,\App\Product,id|variant_id,\App\Variant,id|product_batch_id,\App\ProductBatch,id
     * @mixin _IH_ProductQuotation_QB
     */
    class ProductQuotation extends Model {}

    /**
     * @property int $id
     * @property int $return_id
     * @property int $product_id
     * @property float $qty
     * @property int $sale_unit_id
     * @property float $net_unit_price
     * @property float $discount
     * @property float $tax_rate
     * @property float $tax
     * @property float $total
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $variant_id
     * @property int|null $product_batch_id
     * @property string|null $imei_number
     * @method static _IH_ProductReturn_QB onWriteConnection()
     * @method _IH_ProductReturn_QB newQuery()
     * @method static _IH_ProductReturn_QB on(null|string $connection = null)
     * @method static _IH_ProductReturn_QB query()
     * @method static _IH_ProductReturn_QB with(array|string $relations)
     * @method _IH_ProductReturn_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductReturn_C|ProductReturn[] all()
     * @ownLinks return_id,\App\Returns,id|product_id,\App\Product,id|variant_id,\App\Variant,id|product_batch_id,\App\ProductBatch,id
     * @mixin _IH_ProductReturn_QB
     */
    class ProductReturn extends Model {}

    /**
     * @property int $id
     * @property int $transfer_id
     * @property int $product_id
     * @property float $qty
     * @property int $purchase_unit_id
     * @property float $net_unit_cost
     * @property float $tax_rate
     * @property float $tax
     * @property float $total
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $variant_id
     * @property int|null $product_batch_id
     * @property string|null $imei_number
     * @method static _IH_ProductTransfer_QB onWriteConnection()
     * @method _IH_ProductTransfer_QB newQuery()
     * @method static _IH_ProductTransfer_QB on(null|string $connection = null)
     * @method static _IH_ProductTransfer_QB query()
     * @method static _IH_ProductTransfer_QB with(array|string $relations)
     * @method _IH_ProductTransfer_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductTransfer_C|ProductTransfer[] all()
     * @ownLinks transfer_id,\App\Transfer,id|product_id,\App\Product,id|variant_id,\App\Variant,id|product_batch_id,\App\ProductBatch,id
     * @mixin _IH_ProductTransfer_QB
     */
    class ProductTransfer extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property int $variant_id
     * @property int $position
     * @property string $item_code
     * @property float|null $additional_price
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property float $qty
     * @method static _IH_ProductVariant_QB onWriteConnection()
     * @method _IH_ProductVariant_QB newQuery()
     * @method static _IH_ProductVariant_QB on(null|string $connection = null)
     * @method static _IH_ProductVariant_QB query()
     * @method static _IH_ProductVariant_QB with(array|string $relations)
     * @method _IH_ProductVariant_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductVariant_C|ProductVariant[] all()
     * @ownLinks product_id,\App\Product,id|variant_id,\App\Variant,id
     * @mixin _IH_ProductVariant_QB
     */
    class ProductVariant extends Model {}

    /**
     * @property int $id
     * @property int $sale_id
     * @property int $product_id
     * @property float $qty
     * @property int $sale_unit_id
     * @property float $net_unit_price
     * @property float $discount
     * @property float $tax_rate
     * @property float $tax
     * @property float $total
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $variant_id
     * @property int|null $product_batch_id
     * @property string|null $imei_number
     * @method static _IH_Product_Sale_QB onWriteConnection()
     * @method _IH_Product_Sale_QB newQuery()
     * @method static _IH_Product_Sale_QB on(null|string $connection = null)
     * @method static _IH_Product_Sale_QB query()
     * @method static _IH_Product_Sale_QB with(array|string $relations)
     * @method _IH_Product_Sale_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Product_Sale_C|Product_Sale[] all()
     * @ownLinks sale_id,\App\Sale,id|product_id,\App\Product,id|variant_id,\App\Variant,id|product_batch_id,\App\ProductBatch,id
     * @mixin _IH_Product_Sale_QB
     */
    class Product_Sale extends Model {}

    /**
     * @method static _IH_Product_Supplier_QB onWriteConnection()
     * @method _IH_Product_Supplier_QB newQuery()
     * @method static _IH_Product_Supplier_QB on(null|string $connection = null)
     * @method static _IH_Product_Supplier_QB query()
     * @method static _IH_Product_Supplier_QB with(array|string $relations)
     * @method _IH_Product_Supplier_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Product_Supplier_C|Product_Supplier[] all()
     * @mixin _IH_Product_Supplier_QB
     */
    class Product_Supplier extends Model {}

    /**
     * @property int $id
     * @property string $product_id
     * @property int $warehouse_id
     * @property float $qty
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $variant_id
     * @property float|null $price
     * @property int|null $product_batch_id
     * @property string|null $imei_number
     * @method static _IH_Product_Warehouse_QB onWriteConnection()
     * @method _IH_Product_Warehouse_QB newQuery()
     * @method static _IH_Product_Warehouse_QB on(null|string $connection = null)
     * @method static _IH_Product_Warehouse_QB query()
     * @method static _IH_Product_Warehouse_QB with(array|string $relations)
     * @method _IH_Product_Warehouse_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Product_Warehouse_C|Product_Warehouse[] all()
     * @ownLinks product_id,\App\Product,id|warehouse_id,\App\Warehouse,id|variant_id,\App\Variant,id|product_batch_id,\App\ProductBatch,id
     * @mixin _IH_Product_Warehouse_QB
     */
    class Product_Warehouse extends Model {}

    /**
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @property Warehouse $warehouse
     * @method BelongsTo|_IH_Warehouse_QB warehouse()
     * @method static _IH_ProductionUnit_QB onWriteConnection()
     * @method _IH_ProductionUnit_QB newQuery()
     * @method static _IH_ProductionUnit_QB on(null|string $connection = null)
     * @method static _IH_ProductionUnit_QB query()
     * @method static _IH_ProductionUnit_QB with(array|string $relations)
     * @method _IH_ProductionUnit_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductionUnit_C|ProductionUnit[] all()
     * @mixin _IH_ProductionUnit_QB
     */
    class ProductionUnit extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $warehouse_id
     * @property int|null $supplier_id
     * @property int $item
     * @property int $total_qty
     * @property float $total_discount
     * @property float $total_tax
     * @property float $total_cost
     * @property float|null $order_tax_rate
     * @property float|null $order_tax
     * @property float|null $order_discount
     * @property float|null $shipping_cost
     * @property float $grand_total
     * @property float $paid_amount
     * @property int $status
     * @property int $payment_status
     * @property string|null $document
     * @property string|null $note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $user_id
     * @property Supplier|null $supplier
     * @method BelongsTo|_IH_Supplier_QB supplier()
     * @property Warehouse $warehouse
     * @method BelongsTo|_IH_Warehouse_QB warehouse()
     * @method static _IH_Purchase_QB onWriteConnection()
     * @method _IH_Purchase_QB newQuery()
     * @method static _IH_Purchase_QB on(null|string $connection = null)
     * @method static _IH_Purchase_QB query()
     * @method static _IH_Purchase_QB with(array|string $relations)
     * @method _IH_Purchase_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Purchase_C|Purchase[] all()
     * @ownLinks warehouse_id,\App\Warehouse,id|supplier_id,\App\Supplier,id|user_id,\App\User,id
     * @foreignLinks id,\App\ProductPurchase,purchase_id|id,\App\Payment,purchase_id
     * @mixin _IH_Purchase_QB
     */
    class Purchase extends Model {}

    /**
     * @property int $id
     * @property int $return_id
     * @property int $product_id
     * @property float $qty
     * @property int $purchase_unit_id
     * @property float $net_unit_cost
     * @property float $discount
     * @property float $tax_rate
     * @property float $tax
     * @property float $total
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $variant_id
     * @property int|null $product_batch_id
     * @property string|null $imei_number
     * @method static _IH_PurchaseProductReturn_QB onWriteConnection()
     * @method _IH_PurchaseProductReturn_QB newQuery()
     * @method static _IH_PurchaseProductReturn_QB on(null|string $connection = null)
     * @method static _IH_PurchaseProductReturn_QB query()
     * @method static _IH_PurchaseProductReturn_QB with(array|string $relations)
     * @method _IH_PurchaseProductReturn_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PurchaseProductReturn_C|PurchaseProductReturn[] all()
     * @ownLinks return_id,\App\Returns,id|product_id,\App\Product,id|variant_id,\App\Variant,id|product_batch_id,\App\ProductBatch,id
     * @mixin _IH_PurchaseProductReturn_QB
     */
    class PurchaseProductReturn extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $biller_id
     * @property int|null $supplier_id
     * @property int $customer_id
     * @property int $warehouse_id
     * @property int $item
     * @property float $total_qty
     * @property float $total_discount
     * @property float $total_tax
     * @property float $total_price
     * @property float|null $order_tax_rate
     * @property float|null $order_tax
     * @property float|null $order_discount
     * @property float|null $shipping_cost
     * @property float $grand_total
     * @property int $quotation_status
     * @property string|null $document
     * @property string|null $note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $user_id
     * @property Biller $biller
     * @method BelongsTo|_IH_Biller_QB biller()
     * @property Customer $customer
     * @method BelongsTo|_IH_Customer_QB customer()
     * @property Supplier|null $supplier
     * @method BelongsTo|_IH_Supplier_QB supplier()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property Warehouse $warehouse
     * @method BelongsTo|_IH_Warehouse_QB warehouse()
     * @method static _IH_Quotation_QB onWriteConnection()
     * @method _IH_Quotation_QB newQuery()
     * @method static _IH_Quotation_QB on(null|string $connection = null)
     * @method static _IH_Quotation_QB query()
     * @method static _IH_Quotation_QB with(array|string $relations)
     * @method _IH_Quotation_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Quotation_C|Quotation[] all()
     * @ownLinks biller_id,\App\Biller,id|supplier_id,\App\Supplier,id|customer_id,\App\Customer,id|warehouse_id,\App\Warehouse,id|user_id,\App\User,id
     * @foreignLinks id,\App\ProductQuotation,quotation_id
     * @mixin _IH_Quotation_QB
     */
    class Quotation extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int|null $supplier_id
     * @property int $warehouse_id
     * @property int $user_id
     * @property int $account_id
     * @property int $item
     * @property float $total_qty
     * @property float $total_discount
     * @property float $total_tax
     * @property float $total_cost
     * @property float|null $order_tax_rate
     * @property float|null $order_tax
     * @property float $grand_total
     * @property string|null $document
     * @property string|null $return_note
     * @property string|null $staff_note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Supplier|null $supplier
     * @method BelongsTo|_IH_Supplier_QB supplier()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property Warehouse $warehouse
     * @method BelongsTo|_IH_Warehouse_QB warehouse()
     * @method static _IH_ReturnPurchase_QB onWriteConnection()
     * @method _IH_ReturnPurchase_QB newQuery()
     * @method static _IH_ReturnPurchase_QB on(null|string $connection = null)
     * @method static _IH_ReturnPurchase_QB query()
     * @method static _IH_ReturnPurchase_QB with(array|string $relations)
     * @method _IH_ReturnPurchase_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ReturnPurchase_C|ReturnPurchase[] all()
     * @ownLinks supplier_id,\App\Supplier,id|warehouse_id,\App\Warehouse,id|user_id,\App\User,id|account_id,\App\Account,id
     * @mixin _IH_ReturnPurchase_QB
     */
    class ReturnPurchase extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $customer_id
     * @property int $warehouse_id
     * @property int $biller_id
     * @property int $item
     * @property float $total_qty
     * @property float $total_discount
     * @property float $total_tax
     * @property float $total_price
     * @property float|null $order_tax_rate
     * @property float|null $order_tax
     * @property float $grand_total
     * @property string|null $document
     * @property string|null $return_note
     * @property string|null $staff_note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $user_id
     * @property int $account_id
     * @property int|null $cash_register_id
     * @property Biller $biller
     * @method BelongsTo|_IH_Biller_QB biller()
     * @property Customer $customer
     * @method BelongsTo|_IH_Customer_QB customer()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property Warehouse $warehouse
     * @method BelongsTo|_IH_Warehouse_QB warehouse()
     * @method static _IH_Returns_QB onWriteConnection()
     * @method _IH_Returns_QB newQuery()
     * @method static _IH_Returns_QB on(null|string $connection = null)
     * @method static _IH_Returns_QB query()
     * @method static _IH_Returns_QB with(array|string $relations)
     * @method _IH_Returns_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Returns_C|Returns[] all()
     * @ownLinks customer_id,\App\Customer,id|warehouse_id,\App\Warehouse,id|biller_id,\App\Biller,id|user_id,\App\User,id|account_id,\App\Account,id|cash_register_id,\App\CashRegister,id
     * @foreignLinks id,\App\ProductReturn,return_id|id,\App\PurchaseProductReturn,return_id
     * @mixin _IH_Returns_QB
     */
    class Returns extends Model {}

    /**
     * @property int $id
     * @property float $per_point_amount
     * @property float $minimum_amount
     * @property int|null $duration
     * @property string|null $type
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_RewardPointSetting_QB onWriteConnection()
     * @method _IH_RewardPointSetting_QB newQuery()
     * @method static _IH_RewardPointSetting_QB on(null|string $connection = null)
     * @method static _IH_RewardPointSetting_QB query()
     * @method static _IH_RewardPointSetting_QB with(array|string $relations)
     * @method _IH_RewardPointSetting_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RewardPointSetting_C|RewardPointSetting[] all()
     * @mixin _IH_RewardPointSetting_QB
     */
    class RewardPointSetting extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $guard_name
     * @method static _IH_Roles_QB onWriteConnection()
     * @method _IH_Roles_QB newQuery()
     * @method static _IH_Roles_QB on(null|string $connection = null)
     * @method static _IH_Roles_QB query()
     * @method static _IH_Roles_QB with(array|string $relations)
     * @method _IH_Roles_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Roles_C|Roles[] all()
     * @foreignLinks id,\App\User,role_id
     * @mixin _IH_Roles_QB
     */
    class Roles extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $customer_id
     * @property int $warehouse_id
     * @property int $biller_id
     * @property int $item
     * @property float $total_qty
     * @property float $total_discount
     * @property float $total_tax
     * @property float $total_price
     * @property float $grand_total
     * @property float|null $order_tax_rate
     * @property float|null $order_tax
     * @property float|null $order_discount
     * @property float|null $shipping_cost
     * @property int $sale_status
     * @property int $payment_status
     * @property string|null $document
     * @property float|null $paid_amount
     * @property string|null $sale_note
     * @property string|null $staff_note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $user_id
     * @property int|null $coupon_id
     * @property float|null $coupon_discount
     * @property int|null $cash_register_id
     * @property Biller $biller
     * @method BelongsTo|_IH_Biller_QB biller()
     * @property Customer $customer
     * @method BelongsTo|_IH_Customer_QB customer()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property Warehouse $warehouse
     * @method BelongsTo|_IH_Warehouse_QB warehouse()
     * @method static _IH_Sale_QB onWriteConnection()
     * @method _IH_Sale_QB newQuery()
     * @method static _IH_Sale_QB on(null|string $connection = null)
     * @method static _IH_Sale_QB query()
     * @method static _IH_Sale_QB with(array|string $relations)
     * @method _IH_Sale_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Sale_C|Sale[] all()
     * @ownLinks customer_id,\App\Customer,id|warehouse_id,\App\Warehouse,id|biller_id,\App\Biller,id|user_id,\App\User,id|coupon_id,\App\Coupon,id|cash_register_id,\App\CashRegister,id
     * @foreignLinks id,\App\Product_Sale,sale_id|id,\App\Payment,sale_id|id,\App\Delivery,sale_id
     * @mixin _IH_Sale_QB
     */
    class Sale extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $warehouse_id
     * @property string|null $category_id
     * @property string|null $brand_id
     * @property int $user_id
     * @property string $type
     * @property string|null $initial_file
     * @property string|null $final_file
     * @property string|null $note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool $is_adjusted
     * @method static _IH_StockCount_QB onWriteConnection()
     * @method _IH_StockCount_QB newQuery()
     * @method static _IH_StockCount_QB on(null|string $connection = null)
     * @method static _IH_StockCount_QB query()
     * @method static _IH_StockCount_QB with(array|string $relations)
     * @method _IH_StockCount_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StockCount_C|StockCount[] all()
     * @ownLinks warehouse_id,\App\Warehouse,id|category_id,\App\Category,id|brand_id,\App\Brand,id|user_id,\App\User,id
     * @mixin _IH_StockCount_QB
     */
    class StockCount extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string|null $image
     * @property string $company_name
     * @property string|null $vat_number
     * @property string $email
     * @property string $phone_number
     * @property string $address
     * @property string $city
     * @property string|null $state
     * @property string|null $postal_code
     * @property string|null $country
     * @property bool|null $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Supplier_QB onWriteConnection()
     * @method _IH_Supplier_QB newQuery()
     * @method static _IH_Supplier_QB on(null|string $connection = null)
     * @method static _IH_Supplier_QB query()
     * @method static _IH_Supplier_QB with(array|string $relations)
     * @method _IH_Supplier_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Supplier_C|Supplier[] all()
     * @foreignLinks id,\App\Purchase,supplier_id|id,\App\Quotation,supplier_id|id,\App\ReturnPurchase,supplier_id
     * @mixin _IH_Supplier_QB
     */
    class Supplier extends Model {}

    /**
     * @property Floors $floor
     * @method BelongsTo|_IH_Floors_QB floor()
     * @method static _IH_Tables_QB onWriteConnection()
     * @method _IH_Tables_QB newQuery()
     * @method static _IH_Tables_QB on(null|string $connection = null)
     * @method static _IH_Tables_QB query()
     * @method static _IH_Tables_QB with(array|string $relations)
     * @method _IH_Tables_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Tables_C|Tables[] all()
     * @mixin _IH_Tables_QB
     */
    class Tables extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property float $rate
     * @property bool|null $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Tax_QB onWriteConnection()
     * @method _IH_Tax_QB newQuery()
     * @method static _IH_Tax_QB on(null|string $connection = null)
     * @method static _IH_Tax_QB query()
     * @method static _IH_Tax_QB with(array|string $relations)
     * @method _IH_Tax_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Tax_C|Tax[] all()
     * @foreignLinks id,\App\Product,tax_id
     * @mixin _IH_Tax_QB
     */
    class Tax extends Model {}

    /**
     * @property int $id
     * @property string $reference_no
     * @property int $status
     * @property int $from_warehouse_id
     * @property int $to_warehouse_id
     * @property int $item
     * @property float $total_qty
     * @property float $total_tax
     * @property float $total_cost
     * @property float|null $shipping_cost
     * @property float $grand_total
     * @property string|null $document
     * @property string|null $note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $user_id
     * @property Warehouse $fromWarehouse
     * @method BelongsTo|_IH_Warehouse_QB fromWarehouse()
     * @property Warehouse $toWarehouse
     * @method BelongsTo|_IH_Warehouse_QB toWarehouse()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Transfer_QB onWriteConnection()
     * @method _IH_Transfer_QB newQuery()
     * @method static _IH_Transfer_QB on(null|string $connection = null)
     * @method static _IH_Transfer_QB query()
     * @method static _IH_Transfer_QB with(array|string $relations)
     * @method _IH_Transfer_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Transfer_C|Transfer[] all()
     * @ownLinks user_id,\App\User,id
     * @foreignLinks id,\App\ProductTransfer,transfer_id
     * @mixin _IH_Transfer_QB
     */
    class Transfer extends Model {}

    /**
     * @property int $id
     * @property string $unit_code
     * @property string $unit_name
     * @property int|null $base_unit
     * @property string|null $operator
     * @property float|null $operation_value
     * @property bool|null $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Unit_QB onWriteConnection()
     * @method _IH_Unit_QB newQuery()
     * @method static _IH_Unit_QB on(null|string $connection = null)
     * @method static _IH_Unit_QB query()
     * @method static _IH_Unit_QB with(array|string $relations)
     * @method _IH_Unit_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Unit_C|Unit[] all()
     * @foreignLinks id,\App\Product,unit_id
     * @mixin _IH_Unit_QB
     */
    class Unit extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property string $password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $phone
     * @property string|null $company_name
     * @property int $role_id
     * @property bool $is_active
     * @property bool $is_deleted
     * @property int|null $biller_id
     * @property int|null $warehouse_id
     * @property _IH_Holiday_C|Holiday[] $holiday
     * @property-read int $holiday_count
     * @method HasMany|_IH_Holiday_QB holiday()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @ownLinks role_id,\Spatie\Permission\Models\Role,id|biller_id,\App\Biller,id|warehouse_id,\App\Warehouse,id
     * @foreignLinks id,\App\Customer,user_id|id,\App\Purchase,user_id|id,\App\Sale,user_id|id,\App\Payment,user_id|id,\App\Quotation,user_id|id,\App\Transfer,user_id|id,\App\Returns,user_id|id,\App\Delivery,user_id|id,\App\Expense,user_id|id,\App\GiftCard,user_id|id,\App\GiftCardRecharge,user_id|id,\App\Deposit,user_id|id,\App\Coupon,user_id|id,\App\ReturnPurchase,user_id|id,\App\Employee,user_id|id,\App\Payroll,user_id|id,\App\Attendance,user_id|id,\App\StockCount,user_id|id,\App\Holiday,user_id|id,\App\CashRegister,user_id
     * @mixin _IH_User_QB
     */
    class User extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Variant_C|Variant[] $product
     * @property-read int $product_count
     * @method BelongsToMany|_IH_Variant_QB product()
     * @method static _IH_Variant_QB onWriteConnection()
     * @method _IH_Variant_QB newQuery()
     * @method static _IH_Variant_QB on(null|string $connection = null)
     * @method static _IH_Variant_QB query()
     * @method static _IH_Variant_QB with(array|string $relations)
     * @method _IH_Variant_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Variant_C|Variant[] all()
     * @foreignLinks id,\App\ProductPurchase,variant_id|id,\App\Product_Warehouse,variant_id|id,\App\Product_Sale,variant_id|id,\App\ProductQuotation,variant_id|id,\App\ProductTransfer,variant_id|id,\App\ProductAdjustment,variant_id|id,\App\ProductReturn,variant_id|id,\App\PurchaseProductReturn,variant_id|id,\App\ProductVariant,variant_id
     * @mixin _IH_Variant_QB
     */
    class Variant extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string|null $phone
     * @property string|null $email
     * @property string $address
     * @property bool|null $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Product_C|Product[] $product
     * @property-read int $product_count
     * @method HasMany|_IH_Product_QB product()
     * @method static _IH_Warehouse_QB onWriteConnection()
     * @method _IH_Warehouse_QB newQuery()
     * @method static _IH_Warehouse_QB on(null|string $connection = null)
     * @method static _IH_Warehouse_QB query()
     * @method static _IH_Warehouse_QB with(array|string $relations)
     * @method _IH_Warehouse_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Warehouse_C|Warehouse[] all()
     * @foreignLinks id,\App\User,warehouse_id|id,\App\Purchase,warehouse_id|id,\App\Product_Warehouse,warehouse_id|id,\App\Sale,warehouse_id|id,\App\Quotation,warehouse_id|id,\App\Adjustment,warehouse_id|id,\App\Returns,warehouse_id|id,\App\PosSetting,warehouse_id|id,\App\Expense,warehouse_id|id,\App\ReturnPurchase,warehouse_id|id,\App\StockCount,warehouse_id|id,\App\CashRegister,warehouse_id
     * @mixin _IH_Warehouse_QB
     */
    class Warehouse extends Model {}
}
